#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1  DimGray
#property indicator_color2  Red
#property indicator_color3  Lime
#property indicator_color4  Gold
#property indicator_width4  1
#property indicator_style2  STYLE_DOT
#property indicator_style3  STYLE_DOT

//
//
//
//
//

extern int    RSIPeriod        = 2;
extern int    RSIPrice         = PRICE_CLOSE;
extern int    HighLowPeriod    = 13;
extern int    T3Period         = 5;
extern double T3Hot            = 0.8;
extern bool   T3Original       = true;
extern bool   ShowChannel      = true;
extern bool   ShowZigZag       = false;
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = false;
extern bool   alertsEmail      = false;
extern bool   alertsNotify     = false;
extern string soundFile        = "alert2.wav";
extern bool   ShowArrows       = true;
extern string arrowsIdentifier = "rsi Arrows1";
extern double arrowsUpperGap   = 0.5;
extern double arrowsLowerGap   = 0.5;
extern color  arrowsUpColor    = LimeGreen;
extern color  arrowsDnColor    = Red;
extern int    arrowsUpCode     = 241;
extern int    arrowsDnCode     = 242;


//
//
//
//
//


double T3RSIBuffer[];
double HighBuffer[];
double LowBuffer[];
double ZigZagBuffer[];
double ZigZagLow[];
double ZigZagHigh[];
double trend[];

double emas[][6];
double alpha;
double c1;
double c2;
double c3;
double c4;

//
//
//
//
//

int init()
{
   IndicatorBuffers(7);
   SetIndexBuffer(0,ZigZagBuffer);
   SetIndexBuffer(1,HighBuffer);
   SetIndexBuffer(2,LowBuffer);
   SetIndexBuffer(3,T3RSIBuffer);
   SetIndexBuffer(4,ZigZagLow);
   SetIndexBuffer(5,ZigZagHigh);
   SetIndexBuffer(6,trend);
   SetIndexStyle(0,DRAW_SECTION);
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(3,0);
   SetIndexEmptyValue(4,0);
   SetIndexEmptyValue(5,0);
   SetIndexLabel(0,NULL);

   if (ShowChannel)
   {
      SetIndexStyle(1,DRAW_LINE);
      SetIndexStyle(2,DRAW_LINE);
   }
   else      
   {
     SetIndexStyle(1,DRAW_NONE);
     SetIndexStyle(2,DRAW_NONE);
   }

      double a  = T3Hot;
             c1 = -a*a*a;
             c2 =  3*(a*a+a*a*a);
             c3 = -3*(2*a*a+a+a*a*a);
             c4 = 1+3*a+a*a*a+3*a*a;

      T3Period = MathMax(1,T3Period);
      if (T3Original)
           alpha = 2.0/(1.0 + T3Period);
      else alpha = 2.0/(2.0 + (T3Period-1.0)/2.0);
   IndicatorShortName("RSIchannel");
   return(0);
}
int deinit()
{
   deleteArrows();
return(0);
}  



int start()
{
   int lastZag;
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (ArrayRange(emas,0) != Bars) ArrayResize(emas,Bars);

   //
   //
   //
   //
   //

   if (ShowZigZag)
   for (lastZag=limit+1; lastZag<Bars; lastZag++) if (ZigZagLow[lastZag] != 0 || ZigZagHigh[lastZag] != 0) break;
   for(int i=limit; i>=0; i--) 
   {
      T3RSIBuffer[i] = iT3(iRSI(NULL,0,RSIPeriod,RSIPrice,i),i);
      LowBuffer[i]   = T3RSIBuffer[ArrayMinimum(T3RSIBuffer,HighLowPeriod,i)];
      HighBuffer[i]  = T3RSIBuffer[ArrayMaximum(T3RSIBuffer,HighLowPeriod,i)];
      
      //
      //
      //
      //
      //
            
      trend[i] = trend[i+1];
      if (T3RSIBuffer[i]>LowBuffer[i]  && T3RSIBuffer[i+1] <= LowBuffer[i+1])   trend[i] = 1;
      if (T3RSIBuffer[i]<HighBuffer[i] && T3RSIBuffer[i+1] >= HighBuffer[i+1])  trend[i] =-1;  
            
     //
     //
     //
     //
     //
     
     if (ShowArrows)
     {
       deleteArrow(Time[i]);
       if (trend[i] != trend[i+1])
       {
         if (trend[i] == 1)  drawArrow(i,arrowsUpColor,arrowsUpCode,false);
         if (trend[i] ==-1)  drawArrow(i,arrowsDnColor,arrowsDnCode, true);
       }
     }
      
      
         if (!ShowZigZag) continue;


         
         ZigZagLow[i]  = 0;
         ZigZagHigh[i] = 0;
         if (LowBuffer[i] < LowBuffer[i+1])
            {
               if (ZigZagBuffer[lastZag] == LowBuffer[lastZag])
                   ZigZagBuffer[lastZag] = 0;
                   ZigZagBuffer[i]       =  LowBuffer[i];
                   ZigZagLow[i]          =  LowBuffer[i];
                                 lastZag = i;
                                 continue;
            }
         if (HighBuffer[i] > HighBuffer[i+1])
            {
               if (ZigZagBuffer[lastZag] == HighBuffer[lastZag])
                   ZigZagBuffer[lastZag] = 0;
                   ZigZagBuffer[i]       =  HighBuffer[i];
                   ZigZagHigh[i]         =  HighBuffer[i];
                                 lastZag = i;
                                 continue;
            }
         if (ZigZagBuffer[i] != 0)
            {
               ZigZagBuffer[i] = 0;
               for (lastZag=i+1; lastZag<Bars; lastZag++)
               {
                  if (ZigZagLow[lastZag]  != 0) { ZigZagBuffer[lastZag] = ZigZagLow[lastZag];  break; }
                  if (ZigZagHigh[lastZag] != 0) { ZigZagBuffer[lastZag] = ZigZagHigh[lastZag]; break; }
               }
            }
            
    }
   
   //
   //
   //
   //
   //
      
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (trend[whichBar] != trend[whichBar+1])
      if (trend[whichBar] == 1)
            doAlert("leaving lower level");
      else  doAlert("leaving upper level");       
   }       
return(0);
}

//
//
//
//
//

double iT3(double price,int shift)
{
   int i = Bars-shift-1;
   if (i < 1)
      {
         emas[i][0] = price;
         emas[i][1] = price;
         emas[i][2] = price;
         emas[i][3] = price;
         emas[i][4] = price;
         emas[i][5] = price;
      }
   else
      {
         emas[i][0] = emas[i-1][0]+alpha*(price     -emas[i-1][0]);
         emas[i][1] = emas[i-1][1]+alpha*(emas[i][0]-emas[i-1][1]);
         emas[i][2] = emas[i-1][2]+alpha*(emas[i][1]-emas[i-1][2]);
         emas[i][3] = emas[i-1][3]+alpha*(emas[i][2]-emas[i-1][3]);
         emas[i][4] = emas[i-1][4]+alpha*(emas[i][3]-emas[i-1][4]);
         emas[i][5] = emas[i-1][5]+alpha*(emas[i][4]-emas[i-1][5]);
      }
   return(c1*emas[i][5] + c2*emas[i][4] + c3*emas[i][3] + c4*emas[i][2]);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," rsi channel ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," rsi channel "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}





